
# Transient Acceleration App Note Example

import FXLS8471Q
import aardvark_setup
from aardvark_py import *
import time
import math
from config import *

# Print Revision

print "AN4693 SW Rev: " + str(REVISION)

# Setup Aardvark

(handle, INT1_PIN) = aardvark_setup.setup_aardvark()

# Update aardvark handle in FXLS8471Q.py

FXLS8471Q.handle = handle

# Reset 

FXLS8471Q.reset_FXLS8471Q()

# TRANSIENT_THS:  63mg x 5 = 315mg, debounce behavior:
# clear when condition not true

FXLS8471Q.write_byte_FXLS8471Q_chk( [0x1F, 0x85] )  # write a byte 0x85 to address 0x1F

# TRANSIENT_COUNT = 40ms (based on ODR, datasheet table 117)

FXLS8471Q.write_byte_FXLS8471Q_chk( [0x20, 0x02] )

# A_TRAN_INIT_MSB... initial reference set to 0g for all axes

FXLS8471Q.write_byte_FXLS8471Q_chk( [0x79, 0x00] )
FXLS8471Q.write_byte_FXLS8471Q_chk( [0x7A, 0x00] )
FXLS8471Q.write_byte_FXLS8471Q_chk( [0x7B, 0x00] )
FXLS8471Q.write_byte_FXLS8471Q_chk( [0x7C, 0x00] )

# TRANSIENT_CFG: 
# tran_qs_ele = 1 => event latching enabled
# tran_qs_zefe = 0 => do not detect events on z-axis
# tran_qs_yefe = 1 => y-axis event detection enabled
# tran_qs_xefe = 1 => x-axis event detection enabled
# tran_qs_hpf_byp = 0 => high-pass filter is NOT bypassed

FXLS8471Q.write_byte_FXLS8471Q_chk( [0x1D, 0b00010110] )	

# enable interrupts for the feature using CTRL_REG4

FXLS8471Q.write_byte_FXLS8471Q_chk( [0x2D, 0x20] )

# route interrupts to INT1 pin using CTRL_REG5

FXLS8471Q.write_byte_FXLS8471Q_chk( [0x2E, 0x20] )

# Enable device with ODR = 12.5Hz using CTRL_REG1, 
# OSR=NORMAL (def) 

FXLS8471Q.write_byte_FXLS8471Q_chk( [0x2A, 0x29] )

# Wait for INT1 to assert and clear interrupt by reading register TRANSIENT_SRC (0x1E)

while( True ):
    transition = aa_gpio_change( handle, 100 )
    if (transition & INT1_PIN ) == INT1_PIN:
        print "No interrupt..."
        continue
    (count, dataIn) = FXLS8471Q.read_FXLS8471Q( 0x1E, 1 )
    print "TRAN_SRC = 0x%X" % dataIn[0]
    if( (dataIn[0] & 0x40) == 0x40 ):
        print "Event detected!!!"
